-----------------------------------------------------------------------------------------------
-- batch_verify_CLN_ADDRESSES.sql
--
-- Verify the addresses in the Application Address table (CLN_ADDRESSES)
--  * fn_max_verify
--       - maximum number of address to verify
--  * fb_update
--       - TRUE  = update the record and show results
--       - FALSE = don't update, only show results
--  * fb_only_unverified
--       - TRUE  = Only update unverified records
--       - FALSE = Update ALL records
--  * fv_address_type
--       - Application Address Type - only verify this type
--       - NULL = to verify all address types
--  * fn_days_back
--       - Verify Addresses that were updated/created this many days back
--         - Note: You can enter fractional days such as 0.25, 0.5, etc
--       - NULL = all addresses
--  * fb_skip_international
--       - Skip international address verification in batch mode
--  * fb_verify_inactive
--       - Verify inactive addresses as well as active ones
--                          - This essentially ignores the "to date" and status indicator on the record
--  * fd_from_date / fd_to_date
--       - Specify a date range for the verification based on EFFDT
--       - This is useful for segmenting the data to create parallel batch procedures,
--         increasing throughput
--  * fv_state
--       - Specify an individual state to verify
--
-- History:
--   1/8/2007     Created
--
-- Copyright (c) 2007 Runner Technologies, Inc.  All Rights Reserved.
-- www.RunnerTechnologies.com   sales@RunnerTechnologies.com   877-784-0003  561-395-9322
-----------------------------------------------------------------------------------------------
set serverout on size 1000000

prompt # Verify the addresses in the Application Address table (CLN_ADDRESSES)
BEGIN
  CLEAN_Address_APP.Batch_Verify_CLN_ADDRESSES (
                     fn_max_verify         => 50000000
                    ,fb_update             => TRUE
                    ,fb_only_unverified    => FALSE
                    ,fv_address_type       => NULL
                    ,fn_days_back          => NULL
                    ,fb_skip_international => TRUE
                    ,fb_verify_inactive    => FALSE
                    ,fd_from_date          => NULL
                    ,fd_to_date            => NULL
                    ,fv_state              => NULL
                    );
END;
/

